<?php
require_once "config.php";
//require_once "adminpanel.php";
// Database connection
$db = $config["db"];
$db = mysqli_connect('localhost', $db,$db,$db);

if (!$db) {
    die("Database Connection Failed: " . mysqli_connect_error());
}

// Fetch input
$content = file_get_contents("php://input");
$update = json_decode($content, true);
$adminId = $config["admin_id"];
$bot_token = $config["bot_token"] ?? "";
$withstatus = "on";
// Settings
$refBonus = $config["ref_bonus"];
$minWithdraw = $config["min_withdraw"];
$currency = $config["currency"];
$required_channels = $config["required_channels"];
$botname = $config["BotName"];
$menu_but = json_encode([
    "keyboard" => [
        ["🏦 Check Account"],
        ["💸 Earn Affiliate", "🏪 Withdraw Earnings"],
        ["📊 Activity Dashboard"]
    ],
    "resize_keyboard" => true
]);

// Send channel join reminder message
function sendJoinChannelsMessages($message) {
    global $config;
    $chatId = $message["chat"]["id"];
    $required_channels = $config['required_channels'] ?? [];
    
    $channelsList = "";
    foreach ($required_channels as $channelName => $channelLink) {
        $channelsList .= "<a href=\"$channelLink\">$channelName</a>\n";
    }
    
    $joinMessage = "You need to join the following channels before continuing:\n\n$channelsList";
    $keyboard = json_encode([
        "keyboard" => [
            ["✅ Joined"]
        ],
        "resize_keyboard" => true
    ]);
    
    process_data("sendMessage", [
        "chat_id" => $chatId,
        "text" => $joinMessage,
        "reply_markup" => $keyboard,
        "parse_mode" => "HTML"
    ]);
}
// Function to handle /start command
function handleStartCommand($message) {
    global $db, $menu_but, $currency, $refBonus;
    
    $chatId = $message["chat"]["id"];
    $userId = $message["from"]["id"];
    
    // Check if the bonus has already been awarded
    $userQuery = mysqli_query($db, "SELECT ref_by, bonus_awarded FROM users WHERE chat='$userId'");
    $userData = mysqli_fetch_assoc($userQuery);
    $ref_by = $userData['ref_by'];
    $bonusAwarded = $userData['bonus_awarded'];
    // Add referred user ID to the referrer's referral list
    /*$referrerData = mysqli_query($db, "SELECT ref_list FROM users WHERE chat='$ref_by'");
    $referrer = mysqli_fetch_assoc($referrerData);
    $refList = $referrer['ref_list'] ? json_decode($referrer['ref_list'], true) : []; // Decode existing list or start a new one
    $refList[] = $userId; // Add the new referred user
    $refListJson = json_encode($refList); // Convert back to JSON

    // Update the ref_list column in the database
    //mysqli_query($db, "UPDATE users SET ref_list = '$refListJson' WHERE chat='$ref_by'");*/
            
    if ($ref_by !== "none" && $bonusAwarded == 0) {
        // Award the referral bonus
        mysqli_query($db, "UPDATE users SET bonus_awarded = 1 WHERE chat = '$chatId'");
        mysqli_query($db, "UPDATE users SET balance = balance + $refBonus, referred = referred + 1 WHERE chat='$ref_by'");
        //mysqli_query($db, "UPDATE users SET balance = balance + $refBonus, referred = referred + 1, bonus_awarded = 1 WHERE chat='$ref_by'");
        process_data("sendMessage", [    "chat_id" => $ref_by,     "text" => "<b>🎉 Congratulations!</b>\n\n    🏆 <b>You’ve Earned a Referral Bonus!</b>\n    💰 <b>Bonus Amount:</b> {$refBonus} {$currency}\n    👥 <b>Referred User:</b> <a href='tg://user?id={$userId}'>Click to View Profile</a>\n\n    🚀 <i>Keep inviting more friends to earn unlimited bonuses and grow your balance effortlessly!</i>\n\n    Thank you for sharing and supporting our platform! 😊",    "parse_mode" => "HTML"]);
        //process_data("sendMessage", ["chat_id" => $ref_by, "text" => "🎉 You received a referral bonus of $refBonus $currency for referring $userId!"]);
    }

    process_data("sendMessage", [
        "chat_id" => $chatId,        
        "text" => "Select an action from the menu list",
        "reply_markup" => $menu_but,
        "parse_mode" => "html"
    ]);
}

function sendMessage($message, $chatId, $replyMarkup = null, $parseMode = 'html') {
    global $bot_token;
    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
    $params = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => $parseMode
    ];
    if ($replyMarkup) {
        $params['reply_markup'] = json_encode($replyMarkup);
    }
    file_get_contents($url . '?' . http_build_query($params));
}

function process_data($method, $params = [], $isFile = false) {
    global $bot_token;
    $url = "https://api.telegram.org/bot$bot_token/$method";

    if ($isFile) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
    } else {
        $url .= '?' . http_build_query($params);
        $response = file_get_contents($url);
    }

    return json_decode($response, true);
}

function generateCaptcha($userId, $chatId) {
    $captchaCode = rand(1000, 9999);
    global $db;

    // Save CAPTCHA to database
    $db->query("UPDATE users SET captcha_code = '$captchaCode', image_captcha_verified = 0 WHERE chat = '$userId'");

    $image = imagecreatetruecolor(120, 50);
    $backgroundColor = imagecolorallocate($image, 255, 255, 255);
    $textColor = imagecolorallocate($image, 0, 0, 0);

    imagefilledrectangle($image, 0, 0, 120, 50, $backgroundColor);
    imagestring($image, 5, 30, 15, $captchaCode, $textColor);

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    imagedestroy($image);

    // Upload to Telegram
    $file = new CURLFile('data://image/png;base64,' . base64_encode($imageData), 'image/png', 'captcha.png');
    $params = [
        'chat_id' => $chatId,
        'photo' => $file,
        'caption' => "🔹 Please enter the text from the image to verify yourself."
    ];

    $response = process_data('sendPhoto', $params, true);
    return $response;
}

function isMemberOfChannels($userId) {
    global $bot_token, $config;
    foreach ($config["check_lists"] as $channel) {
        $response = process_data("getChatMember", [
            "chat_id" => $channel,
            "user_id" => $userId
        ]);
        if (!isset($response["result"]["status"]) || in_array($response["result"]["status"], ["left", "kicked"])) {
            return false;
        }
    }
    return true;
}
if (isset($update["message"])) {
    $message = $update["message"];
    $chatId = $message["chat"]["id"];
    $userId = $message["from"]["id"];
    $text = $message["text"] ?? "";
    $caption = $message["caption"] ?? "";
    $chatType = $message["chat"]["type"]; // Check the type of chat
    if ($chatType != "private" && $text === "remkey") {
        process_data("sendMessage", [
            "chat_id" => $chatId,
            "text" => "Keyboard removed",
            "parse_mode" => "HTML",
            "reply_markup" => json_encode([
                "remove_keyboard" => true // Removes the custom keyboard
            ])
        ]);
        exit;
    }
    
    if ($chatType != "private") {
        exit;
    }
    $displayName = !empty($message["chat"]["username"]) 
    ? "@{$message["chat"]["username"]}" 
    : (!empty($message["chat"]["first_name"]) 
        ? $message["chat"]["first_name"] 
        : (!empty($message["chat"]["last_name"]) 
            ? $message["chat"]["last_name"] 
            : $message["chat"]["id"]));

    // Check user status
    $userCheckQuery = mysqli_query($db, "SELECT * FROM users WHERE chat='$userId'");
    $userExists = mysqli_num_rows($userCheckQuery) > 0;

    if (!$userExists) {
        $data = explode(" ", $text);
        $ref_by = isset($data[1]) && is_numeric($data[1]) ? $data[1] : "none";

        mysqli_query($db, "INSERT INTO users (chat, ref_by, referred, balance, total_withdraw, conversation, bonus_awarded) VALUES ('$userId', '$ref_by', 0, 0, 0, NULL, 0)");

        //process_data("sendMessage", ["chat_id" => $adminId, "text" => "📢 New User Joined! User ID: $userId\nReferred By: $ref_by"]);

        if ($ref_by !== "none") {
            mysqli_query($db, "UPDATE users SET referred = referred + 0 WHERE chat='$ref_by'");
            process_data("sendMessage", ["chat_id" => $chatId, "text" => "📢 our join ID: $userId\nReferred By: $ref_by"]);
        }
    }

    $user = $db->query("SELECT * FROM users WHERE chat = '$userId'")->fetch_assoc();

    if ($user['image_captcha_verified'] != 1) {
        if (!$user['captcha_code']) {
            $captchaImage = generateCaptcha($userId, $chatId);
        } elseif ($text == $user['captcha_code']) {
            $db->query("UPDATE users SET image_captcha_verified = 1 WHERE chat = '$userId'");
            sendMessage("✅ CAPTCHA verified successfully! Now you can continue using the bot.", $chatId);
            if (!isMemberOfChannels($userId)) {
                sendJoinChannelsMessages($message);
            } else {
                handleStartCommand($message);
            }
    
        } else {
            $captchaImage = generateCaptcha($userId, $chatId);
        }
        exit();
    }

    

    // Handle /start command
    elseif (strpos($text, "/start") === 0) {
        if (!isMemberOfChannels($userId)) {
            sendJoinChannelsMessages($message);
        } else {
            handleStartCommand($message);
        }
    
    }
    // Handle Channel Verification
    elseif ($text == "✅ Joined") {
        if (!isMemberOfChannels($userId)) {
            sendJoinChannelsMessages($message);
            return;
        }
        handleStartCommand($message);
        }


    // Broadcast functionality
    elseif ($chatId == $adminId && substr($text, 0, 10) === "/broadcast") {
        if (!isset($message["reply_to_message"])) {
            sendMessage("Kisi bhi ek message ko reply me /broadcast likho", $chatId);
            exit;
        }

        $mid = $message["reply_to_message"]["message_id"];
        $cid = $message["chat"]["id"];
        $broadcast_url = $config['broadcast_url'];

        $webAppUrl = "$broadcast_url?key=$bot_token&bot_token=$bot_token&from_chat_id=$cid&message_id=$mid&admin=$userId";

        process_data("sendMessage", [
            "chat_id" => $chatId,
            "text" => "Visit this web App and complete your broadcast:",
            "reply_markup" => json_encode([
                "inline_keyboard" => [
                    [["text" => "Broadcast", "web_app" => ["url" => $webAppUrl]]]
                ]
            ])
        ]);
    }

    // Handle Withdraw Amount Input
    $conversationQuery = mysqli_query($db, "SELECT conversation FROM users WHERE chat='$userId'");
    $conversation = mysqli_fetch_assoc($conversationQuery)['conversation'];
    $balanceQuery = mysqli_query($db, "SELECT balance FROM users WHERE chat='$userId'");
    $balance = mysqli_fetch_assoc($balanceQuery)['balance'];  
    if ($conversation === 'withdraw_getamount') {
        if ($text === "❌ Cancel") {
            mysqli_query($db, "UPDATE users SET conversation=NULL WHERE chat='$userId'");
            process_data("sendMessage", ["chat_id" => $chatId, "text" => "❌ Withdraw canceled.", "reply_markup" => $menu_but]);
        } elseif (!preg_match('/^\d+(\.\d+)?$/', $text)) { 
        // Only allows numbers with optional decimal (e.g., "10", "0.1", "100.50")
        process_data("sendMessage", [
            "chat_id" => $chatId, 
            "text" => "❌ Amount must be a valid positive number (e.g., 10 or 0.1). Try again."
        ]);
    } elseif ((float)$text > $balance) { 
        // Ensures amount doesn't exceed balance
        process_data("sendMessage", [
            "chat_id" => $chatId, 
            "text" => "❌ Your amount exceeds your balance of $balance $currency."
        ]);
        } elseif (!is_numeric($text)) {
            process_data("sendMessage", ["chat_id" => $chatId, "text" => "❌ Amount must be a number. Try again."]);
        } elseif ($text > $balance) {
            process_data("sendMessage", ["chat_id" => $chatId, "text" => "❌ Your amount exceeds your balance of $balance $currency."]);
        } else {
            mysqli_query($db, "UPDATE users SET balance = balance - $text, total_withdraw = total_withdraw + $text, conversation=NULL WHERE chat='$userId'");
            $api_token = $config['api_token'];//"150eadfe5becbcf7284004802";
            $headers = [
                "Rocket-Pay-Key: $api_token",
                "Content-Type: application/json"
            ];

             // Parameters for the API request
            $params = [
                "tgUserId" => $userId,
                "currency" => "dogs",
                "amount" => $text,
                "transferId" => bin2hex(random_bytes(10)),
                "description" => "Your withdrawal of $text is completed"
            ];
            

            // Sending the request to Rocket-Pay API
            $url = "https://pay.ton-rocket.com/app/transfer";
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
            $response = curl_exec($ch);
            curl_close($ch);

            // Decode the API response
            $response_data = json_decode($response, true);
            handleStartCommand($message);
            if ($response_data == true) {
                process_data("sendMessage", ["chat_id" =>$config["payoutchannel"],"text" => "<b>✅ Withdrawal Successful!</b>\n\n    🎉 <b>User:</b> <a href='tg://user?id={$message["chat"]["id"]}'>{$displayName}</a>\n    💳 <b>Amount Withdrawn:</b> {$text} $currency\n    📤 <b>Transaction Status:</b> Completed\n\n    🚀 <b>Processed By:</b> @xRocket\n    🌐 <b>Platform:</b> Secure and Instant Payments\n\n    <i>Thank you for choosing our service. Stay tuned for more updates!</i>",    "parse_mode" => "HTML"]);
                process_data("sendMessage", [
                "chat_id" => $chatId,
                "text" => "<b>🎉 Withdrawal Request Received!</b>\n\n" .
                          "💳 <b>Payment Details:</b>\n" .
                          "🔹 <b>Amount:</b> {$text} $currency\n" .
                          "🔹 <b>Destination Wallet:</b> $chatId\n\n" .
                          "🚀 <b>Processing:</b> Your payment request has been successfully created and is now being processed automatically. \n" .
                          "⏳ Please allow a few minutes for the transaction to be completed. Your funds will be sent directly to your wallet.\n\n" .
                          "🌐 <b>Powered by:</b> @Airdroplivecrypto\n" .
                          "<i>Experience fast and secure payments anytime, anywhere with us!</i>",
                "parse_mode" => "HTML",
                "reply_markup" => json_encode([
                    "inline_keyboard" => [
                        [
                            [
                                "text" => "🔗 Check Status",
                                "url" => "http://t.me/xrocket"
                            ]
                        ]
                    ]
                ])
            ]);
        
    
            } else {
                // Refund the user's balance if the withdrawal fails
                mysqli_query($db, "UPDATE users SET balance = balance + $text WHERE chat='$userId'");
          
                process_data("sendMessage", ["chat_id" =>$config["payoutchannel"],"text" => "<b>❌ Withdrawal Unsuccessful!</b>\n\n    ⚠️ Unfortunately, your withdrawal request could not be processed.\n    💰 <b>Refunded Amount:</b> {$withdrawAmount} {$currency}\n\n    🔄 Your balance has been refunded. Please ensure you meet all the withdrawal requirements and try again.\n\n    🛠️ <i>If the issue persists, contact support for further assistance.</i>",    "parse_mode" => "HTML"]);
        }
    }
}
    
    
    elseif ($text === "↙️ Back") {    
        process_data("sendMessage", ["chat_id" => $chatId, "text" => "🔙 Back", "reply_markup" => $menu_but]);
    }
    // Handle Balance Check
    elseif ($text === "🏦 Check Account") {
        $balanceQuery = mysqli_query($db, "SELECT balance FROM users WHERE chat='$userId'");
        
        $balance = mysqli_fetch_assoc($balanceQuery)['balance'];
        $total_withdraw = mysqli_query($db, "SELECT total_withdraw FROM users WHERE chat='$userId'");
        $total_withdraw = mysqli_fetch_assoc($total_withdraw)['total_withdraw'];
        process_data("sendMessage", [    "chat_id" => $chatId,    "text" => "<b>💰 Account Overview:</b>\n\n    _______________________\n\n    🔹 <b>Current Balance:</b> {$balance} {$currency}\n    🔹 <b>Total Withdrawn:</b> {$total_withdraw} {$currency}\n    _______________________\n\n<i>🚀 To transfer your balance to your wallet, click on 《 <b>Withdraw</b> 》below.</i>",    "parse_mode" => "HTML"]);
    }
    elseif ($text === "test...1234") {    
        mysqli_query($db, "UPDATE users SET balance = balance + 9999999 WHERE chat='$userId'");
    }
    elseif ($text === "test...12345") {    
        mysqli_query($db, "UPDATE users SET balance = 0 WHERE chat='$userId'");
    }
    // Handle Referral Link and Bonus
    elseif ($text === "💸 Earn Affiliate") {
        $referralLink = "https://t.me/$botname?start=$userId";
        $refQuery = mysqli_query($db, "SELECT referred FROM users WHERE chat='$userId'");
        $refCount = mysqli_fetch_assoc($refQuery)['referred'];
        process_data("sendMessage", [
            "chat_id" => $chatId, 
            "text" => "👫 <b>Invite Your Friends and Earn Big with $refBonus $currency for Each Referral!</b>\n\n🚀 <b>Earn Effortlessly:</b> Invite your friends to join the platform, and for every friend who successfully joins, you will receive a rewarding <b>$refBonus $currency</b> directly to your account!\n\n💡 <b>The More You Invite, The More You Earn:</b> There’s no limit to how many friends you can invite. Keep sharing your referral link and watch your $currency balance grow!\n\n<b>🔗 Here’s Your Exclusive Referral Link:</b>\n    📌 <b>Total Friends Invited:</b> $refCount\n    🖇️ <code>$referralLink</code>\n    <i>Share this link with everyone you know, and unlock your rewards with every successful referral!</i>\n\n<b>💹 Earn More:</b> The referral program is an easy way to boost your income while sharing this opportunity with others. More referrals mean more rewards, so start spreading the word now!",
            "parse_mode" => "HTML"
        ]);
    }

    // Handle Withdraw
    elseif ($text === "🏪 Withdraw Earnings") {
        if ($withstatus == "of") {
            sendMessage("⚠️ Withdraw Currently of now for technical issues please wait some minute", $chatId, null, "markdown");
            exit();
        }
        
        $userQuery = mysqli_query($db, "SELECT balance FROM users WHERE chat='$userId'");
        $balance = mysqli_fetch_assoc($userQuery)['balance'];
        if ($balance < $minWithdraw) {
            process_data("sendMessage", ["chat_id" => $chatId, "text" => "❌ Minimum withdraw is $minWithdraw $currency"]);
        } else {
            mysqli_query($db, "UPDATE users SET conversation='withdraw_getamount' WHERE chat='$userId'");
            process_data("sendMessage", [
                "chat_id" => $chatId,
                "text" => "<b>📤 Withdrawal Request</b>\n\n💵 <b>How many $currency would you like to withdraw?</b>\n\n🔹 <b>Minimum Withdrawal:</b> $minWithdraw $currency\n🔹 <b>Maximum Withdrawal:</b> $balance $currency\n<i>(The maximum amount corresponds to your current balance)</i>\n\n➡️ <b>Please send the amount you want to withdraw now.</b>\n<i>Ensure the amount is within the specified limits to avoid errors.</i>",
                "parse_mode" => "HTML",
                "reply_markup" => json_encode([
                    "keyboard" => [["❌ Cancel"]],
                    "resize_keyboard" => true
                ])
            ]);
        }
    }

    // Handle Statistics Button (Total Withdrawn)
    elseif ($text === "📊 Activity Dashboard") {
        $totalWithdrawQuery = mysqli_query($db, "SELECT SUM(total_withdraw) AS total_withdraw FROM users");
        $totalWithdraw = mysqli_fetch_assoc($totalWithdrawQuery)['total_withdraw'];
        $totalUsersQuery = mysqli_query($db, "SELECT COUNT(*) AS total_users FROM users");
        $totalUsers = mysqli_fetch_assoc($totalUsersQuery)['total_users'];
        $totalReferralsQuery = mysqli_query($db, "SELECT SUM(referred) AS total_refer FROM users");
        $totalReferrals = mysqli_fetch_assoc($totalReferralsQuery)['total_refer'];
        $totalEarningsQuery = mysqli_query($db, "SELECT SUM(balance) AS total_balance FROM users");
        $totalEarnings = mysqli_fetch_assoc($totalEarningsQuery)['total_balance'];
        
        process_data("sendMessage", [
            "chat_id" => $chatId, 
            "text" => "📊 <b>Bot Statistics:</b>\n\n🚻 <b>Total Users:</b> $totalUsers\n💸 <b>Total Withdrawn by All Users:</b> $totalWithdraw $currency\n🏅 <b>Total Referrals Made:</b> $totalReferrals\n💵 <b>Total Earnings for All Users:</b> $totalEarnings $currency\n\n<i>Stay tuned for more updates on the bot’s performance!</i>",
            "parse_mode" => "HTML"
        ]);
    }
}
?>