
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    chat VARCHAR(255) NOT NULL UNIQUE,
    balance DECIMAL(20, 8) DEFAULT 0,
    total_withdraw DECIMAL(20, 8) DEFAULT 0,
    referred INT DEFAULT 0,
    ref_by VARCHAR(255) DEFAULT 'none',
    captcha_code VARCHAR(10),
    image_captcha_verified TINYINT DEFAULT 0,
    conversation VARCHAR(255) DEFAULT NULL,
    bonus_awarded TINYINT DEFAULT 0
);

-- Create the admins table
CREATE TABLE IF NOT EXISTS admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    chat_id VARCHAR(255) NOT NULL UNIQUE
);

-- Create the settings table
CREATE TABLE IF NOT EXISTS settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    min_withdraw DECIMAL(20, 8) DEFAULT 0,
    max_withdraw DECIMAL(20, 8) DEFAULT 0,
    per_refer DECIMAL(20, 8) DEFAULT 0,
    bot_status ENUM('on', 'off') DEFAULT 'off',
    withdraw_status ENUM('on', 'off') DEFAULT 'off'
);