<?php
// Database Credentials
require_once "config.php";
$host = 'localhost';
$dbname = $config["db"];
$username = $config["db"];
$password = $config["db"];

header('Content-Type: text/html; charset=UTF-8');

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Fetch all users' chat IDs
$stmt = $pdo->query("SELECT chat FROM users");
$users = $stmt->fetchAll(PDO::FETCH_COLUMN);
$totalUsers = count($users);
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Message Broadcaster</title>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #fff6d4;
            color: #ae1adb;
            text-align: center;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            font-size: 2rem;
            color: #f05330;
        }
        .status {
            background-color: #f7f79c;
            border: 2px solid #ae1adb;
            padding: 15px;
            border-radius: 12px;
            margin-top: 20px;
        }
        button {
            background-color: #ff6347;
            color: #d5ff2d;
            width: 350px;
            height: 50px;
            font-size: 1.2rem;
            cursor: pointer;
            margin: 10px;
            border: 1px solid #ae1adb;
            border-radius: 5px;
        }
        button:disabled {
            background-color: #f5baba;
        }
        .result-box {
            background-color: #f58631;
            border: 2px solid #ae1adb;
            padding: 20px;
            color: #c3fdff;
            margin-top: 30px;
            border-radius: 15px;
            display: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Message Broadcaster</h1>
        <p>Remove blocked chats after broadcasting to free up space.</p>
        <label><input type="checkbox" id="isForward"> Forwarding</label>
        <div class="status">
            <p><strong>Total Chats:</strong> <span id="totalChats"><?= $totalUsers ?></span></p>
            <p><strong>Success:</strong> <span id="completed">0</span></p>
            <p><strong>Failed:</strong> <span id="failed">0</span></p>
        </div>
        <button id="startButton" onclick="startBroadcast()">Broadcast</button>
        <button id="cancelButton" style="display:none;">Cancel</button>
        <div class="result-box" id="resultBox">
            <h2>Broadcast Completed!</h2>
            <p><strong>Total Chats:</strong> <span id="finalTotalChats">0</span></p>
            <p><strong>Success:</strong> <span id="finalCompleted">0</span></p>
            <p><strong>Failed:</strong> <span id="finalFailed">0</span></p>
        </div>
    </div>

<script src="https://telegram.org/js/telegram-web-app.js"></script>
<script>
    const tg = window.Telegram.WebApp;
    tg.setHeaderColor("#fff6d4");

    const botToken = new URLSearchParams(window.location.search).get('bot_token');
    const fromChatId = new URLSearchParams(window.location.search).get('from_chat_id');
    const messageId = new URLSearchParams(window.location.search).get('message_id');

    let totalChats = <?= $totalUsers ?>;
    let completed = 0;
    let failed = 0;
    let failedUsers = [];

    const completedElem = document.getElementById('completed');
    const failedElem = document.getElementById('failed');

    async function startBroadcast() {
        document.getElementById('startButton').disabled = true;
        document.getElementById('cancelButton').style.display = 'inline-block';

        let users = <?= json_encode($users) ?>;
        const BATCH_SIZE = 10;
        let userIndex = 0;

        while (userIndex < users.length) {
            let batch = users.slice(userIndex, userIndex + BATCH_SIZE);
            userIndex += BATCH_SIZE;

            await Promise.all(batch.map(chatId => {
                return sendMessage(botToken, chatId, fromChatId, messageId, document.getElementById('isForward').checked)
                    .then(success => {
                        if (success) completed++;
                        else {
                            failed++;
                            failedUsers.push(chatId);
                        }
                    });
            }));

            completedElem.textContent = completed;
            failedElem.textContent = failed;
        }

        showFinalResult();
    }

    async function sendMessage(botToken, chatId, fromChatId, messageId, isForward) {
        const method = isForward ? "forwardMessage" : "copyMessage";
        const url = `https://api.telegram.org/bot${botToken}/${method}`;
        const data = new URLSearchParams({
            chat_id: chatId,
            from_chat_id: fromChatId,
            message_id: messageId
        });

        try {
            const response = await fetch(url, { method: 'POST', body: data });
            const result = await response.json();
            return result.ok;
        } catch (error) {
            return false;
        }
    }

    function showFinalResult() {
        document.getElementById('cancelButton').style.display = 'none';
        document.getElementById('finalTotalChats').textContent = totalChats;
        document.getElementById('finalCompleted').textContent = completed;
        document.getElementById('finalFailed').textContent = failed;
        document.getElementById('resultBox').style.display = 'block';

        if (failed > 0) removeFailedChats();
    }

    async function removeFailedChats() {
        if (failedUsers.length === 0) return;

        const failedUserIds = failedUsers.join(',');
        const removeApiUrl = `remove-users.php?user_ids=${failedUserIds}`;

        try {
            const response = await fetch(removeApiUrl);
            const result = await response.json();

            if (result.status === 'success') {
                tg.showAlert(`${failedUsers.length} blocked chats removed.`);
            } else {
                tg.showAlert('Failed to remove blocked chats.');
            }
        } catch (error) {
            tg.showAlert('Error while removing blocked chats.');
        }
    }
</script>

</body>
</html>