<?php
require_once "config.php";

// Start session
session_start();

// Get DB Connection
$db = mysqli_connect('localhost', 'tamimwe1_DogsPayInstant12bot', 'tamimwe1_DogsPayInstant12bot', 'tamimwe1_DogsPayInstant12bot'); // Replace with your DB details

if (!$db) {
    die("Database Connection Failed: " . mysqli_connect_error());
}


// Fetch input from Telegram
$content = file_get_contents("php://input");
$update = json_decode($content, true);
$bot_token = $config["bot_token"] ?? "";

// Function to send messages
function createMessage($message, $chatId, $replyMarkup = null) {
    global $bot_token;
    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
    $params = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'html'
    ];
    if ($replyMarkup) {
        $params['reply_markup'] = json_encode($replyMarkup);
    }
    file_get_contents($url . '?' . http_build_query($params));
}

// Function to edit message
function editMessage($message, $chatId, $messageId, $replyMarkup = null) {
    global $bot_token;
    $url = "https://api.telegram.org/bot$bot_token/editMessageText";
    $params = [
        'chat_id' => $chatId,
        'message_id' => $messageId,
        'text' => $message,
        'parse_mode' => 'html'
    ];
    if ($replyMarkup) {
        $params['reply_markup'] = json_encode($replyMarkup);
    }
    file_get_contents($url . '?' . http_build_query($params));
}

// Generate admin panel menu
function getAdminPanelMenu($db) {
    // Fetch settings from the database
    $settingsQuery = mysqli_query($db, "SELECT * FROM settings WHERE id = $cgatId");
    $settings = mysqli_fetch_assoc($settingsQuery);

    return [
        "inline_keyboard" => [
            [["text" => "➕ Add Admin", "callback_data" => "add_admin"]],
            [["text" => "➖ Remove Admin", "callback_data" => "remove_admin"]],
            [["text" => "💰 Set Minimum Withdraw ({$settings['min_withdraw']})", "callback_data" => "set_min_withdraw"]],
            [["text" => "💰 Set Maximum Withdraw ({$settings['max_withdraw']})", "callback_data" => "set_max_withdraw"]],
            [["text" => "🎁 Set Per Refer ({$settings['per_refer']})", "callback_data" => "set_per_refer"]],
            [["text" => "⚙️ Bot Status ({$settings['bot_status']})", "callback_data" => "toggle_bot_status"]],
            [["text" => "🚦 Withdraw Status ({$settings['withdraw_status']})", "callback_data" => "toggle_withdraw_status"]],
            [["text" => "➕ Add Balance", "callback_data" => "add_balance"]],
            [["text" => "➖ Remove Balance", "callback_data" => "remove_balance"]],
            [["text" => "📢 Broadcast", "callback_data" => "broadcast"]],
            [["text" => "❌ Cancel", "callback_data" => "cancel"]]
        ]
    ];
}

// Handle callback queries
if (isset($update["callback_query"])) {
    $callbackQuery = $update["callback_query"];
    $chatId = $callbackQuery["message"]["chat"]["id"];
    $messageId = $callbackQuery["message"]["message_id"];
    $data = $callbackQuery["data"];

    // Fetch settings from database directly for the current status
    $settingsQuery = mysqli_query($db, "SELECT * FROM settings WHERE id = 1");
    $settings = mysqli_fetch_assoc($settingsQuery);

    if ($data === "toggle_bot_status" || $data === "toggle_withdraw_status") {
        $column = $data === "toggle_bot_status" ? "bot_status" : "withdraw_status";
        $newStatus = ($settings[$column] === 'on') ? 'off' : 'on';

        $updateQuery = "UPDATE settings SET $column='$newStatus' WHERE id=1";
        mysqli_query($db, $updateQuery);

        // Refresh settings after update
        $settingsQuery = mysqli_query($db, "SELECT * FROM settings WHERE id = 1");
        $settings = mysqli_fetch_assoc($settingsQuery);
        editMessage("✅ $column updated to: <b>$newStatus</b>", $chatId, $messageId, getAdminPanelMenu($db));
    } elseif ($data === "cancel") {
        editMessage("✅ Action cancelled.", $chatId, $messageId, getAdminPanelMenu($db));
    } else {
        $actions = [
            "add_admin" => "user ID to add as admin",
            "remove_admin" => "user ID to remove from admin",
            "set_min_withdraw" => "minimum withdrawal amount",
            "set_max_withdraw" => "maximum withdrawal amount",
            "set_per_refer" => "referral reward amount",
            "add_balance" => "amount and user ID to add balance (e.g., '10 27272727')",
            "remove_balance" => "amount and user ID to remove balance (e.g., '10 27272727')",
            "broadcast" => "message to broadcast"
        ];
        $message = "📝 Please enter the {$actions[$data]}. Type '❌ Cancel' to cancel.";

        // Update conversation in the database
        $updateQuery = "UPDATE users SET conversation='$data' WHERE chat='$chatId'";
        mysqli_query($db, $updateQuery);

        editMessage($message, $chatId, $messageId, [
            'inline_keyboard' => [[['text' => '❌ Cancel', 'callback_data' => 'cancel']]]
        ]);
    }
}

// Handle user messages
if (isset($update["message"])) {
    $message = $update["message"];
    $chatId = $message["chat"]["id"];
    $text = $message["text"] ?? "";

    // Check conversation from the database
    $userQuery = mysqli_query($db, "SELECT conversation FROM users WHERE chat='$chatId'");
    $userData = mysqli_fetch_assoc($userQuery);
    $conversation = $userData['conversation'] ?? null;

    if ($conversation) {
        switch ($conversation) {
            case "add_admin":
                $query = "INSERT IGNORE INTO admins (chat_id) VALUES ('$text')";
                mysqli_query($db, $query);
                createMessage("✅ User ID $text added as admin.", $chatId);
                break;

            case "remove_admin":
                $query = "DELETE FROM admins WHERE chat_id='$text'";
                mysqli_query($db, $query);
                createMessage("✅ User ID $text removed as admin.", $chatId);
                break;

            case "set_min_withdraw":
                $query = "UPDATE settings SET min_withdraw='$text' WHERE id=1";
                mysqli_query($db, $query);
                createMessage("✅ Minimum withdrawal set to $text.", $chatId);
                break;

            case "set_max_withdraw":
                $query = "UPDATE settings SET max_withdraw='$text' WHERE id=1";
                mysqli_query($db, $query);
                createMessage("✅ Maximum withdrawal set to $text.", $chatId);
                break;

            case "set_per_refer":
                $query = "UPDATE settings SET per_refer='$text' WHERE id=1";
                mysqli_query($db, $query);
                createMessage("✅ Referral reward set to $text.", $chatId);
                break;

            case "add_balance":
            case "remove_balance":
                list($amount, $userId) = explode(' ', $text);
                $operator = $conversation === "add_balance" ? '+' : '-';
                $query = "UPDATE users SET balance = balance $operator $amount WHERE chat='$userId'";
                mysqli_query($db, $query);
                createMessage("✅ Balance updated for user $userId.", $chatId);
                break;

            case "broadcast":
                $query = "SELECT chat FROM users";
                $users = mysqli_query($db, $query);
                while ($user = mysqli_fetch_assoc($users)) {
                    createMessage($text, $user['chat']);
                }
                createMessage("✅ Broadcast sent.", $chatId);
                break;
        }

        // Reset conversation in the database
        $resetQuery = "UPDATE users SET conversation=NULL WHERE chat='$chatId'";
        mysqli_query($db, $resetQuery);
    } elseif ($text === "/adminpanel") {
        createMessage("🔧 Admin Panel {$settings}", $chatId, getAdminPanelMenu($db));
    }
}
?>